#!/usr/bin/env python

import os
import carla

from srunner.autoagents.sensor_interface import SensorInterface
from srunner.tools.route_manipulation import downsample_route

from agent.autonomous_agent import AutonomousAgent
from agent.comm_agent import CommAgent
from agent.atomic_command_follower import AtomicCommandFollower
from comm.transceiver import Transceiver
from utils.partial_observable_captioner import PartialObservableCaptioner

class CommOnlyAgent(CommAgent):
    """
    This class is to host the communication agent in the environment.
    (1) It defines sensors
    (2) Generate vehicle control and send message
    """
    def __init__(self,
                 vehicle,
                 agent_config,
                 ):
        self._agent_config = agent_config
        self._map = vehicle.get_world().get_map()
        self.agent_id = agent_config.name
        self.vehicle = vehicle
        self.sensor_devices = agent_config.sensors
        self.frame_rate = 20
        # Set up the Transceiver
        self.transceiver = Transceiver(vehicle=vehicle,
                                       agent=self,
                                       sharing_mode=True,
                                      )
        # Record the history of messages
        self.received_messages = []

        # Set up global plan
        self._global_plan = None
        self._global_plan_world_coord = None

        # Set up sensor interface
        self.sensor_interface = SensorInterface()
        # Set up captioner
        self.captioner = PartialObservableCaptioner(vehicle,
                                                    perception_range=70,)
        # Set up language plan/goal/task
        self.task = agent_config.task

        self.step_count = 0
        self.decision_frequency = 10

    def run_step(self, action):
        """
        action is in the format of {"command":command, "message":message}
        """
        # Step 3: Send message to other agents
        if action.get("message", None):
            self.transceiver.TX_Language(action["message"])

        # if self.step_count % self.decision_frequency == 0:
        #     if action.get("message", None):
        #             self.received_messages.append({
        #                 'sender': str(self.vehicle.id),
        #                 'message': str(action["message"]),
        #                 'time': self.step_count
        #             })
        # Step 4: Receive message from other agents, update the message history
        # self.message_history.append(self.transceiver.lang_channel.buffer)
        self.step_count += 1
        return None